<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Listing extends Model
{
    protected $fillable = [
        'user_id',
        'title',
        'slug',
        'content',
        'status',
        'location_lat',
        'location_lng',
        'address',
        'price_min',
        'price_max',
        'booking_settings',
        'opening_hours',
        'contact_info',
        'featured_image',
        'gallery',
        'category_id',
        'location_id',
    ];

    protected $casts = [
        'booking_settings' => 'array',
        'opening_hours' => 'array',
        'contact_info' => 'array',
        'gallery' => 'array',
        'price_min' => 'decimal:2',
        'price_max' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }

    public function reviews()
    {
        return $this->hasMany(Review::class);
    }
}
