<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\User; // Added for relationship
use App\Models\Listing; // Added for relationship

class Booking extends Model
{
    protected $fillable = [
        'user_id',
        'listing_id',
        'start_time',
        'end_time',
        'total_price',
        'status',
        'guest_count',
        'gateway',
        'transaction_id',
        'notes',
    ];

    protected $casts = [
        'start_time' => 'datetime',
        'end_time' => 'datetime',
        'total_price' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function listing()
    {
        return $this->belongsTo(Listing::class);
    }
}
