<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ListingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Mapping typical WP structure based on requirement
        return [
            'ID' => $this->id,
            'post_author' => (string) $this->user_id,
            'post_date' => $this->created_at->format('Y-m-d H:i:s'),
            'post_date_gmt' => $this->created_at->setTimezone('UTC')->format('Y-m-d H:i:s'),
            'post_content' => $this->content,
            'post_title' => $this->title,
            'post_excerpt' => substr(strip_tags($this->content), 0, 100), // simplistic excerpt
            'post_status' => $this->status,
            'comment_status' => 'open',
            'ping_status' => 'closed',
            'post_name' => $this->slug,
            'post_type' => 'listar',
            'comment_count' => (string) $this->reviews()->count(),
            'address' => $this->address,
            'phone' => $this->contact_info['phone'] ?? '',
            'longitude' => (string) $this->location_lng,
            'latitude' => (string) $this->location_lat,
            'image' => [
                'full' => ['url' => $this->featured_image],
                'medium' => ['url' => $this->featured_image],
                'thumb' => ['url' => $this->featured_image],
            ],
            'category' => $this->category ? [
                'term_id' => $this->category->id,
                'name' => $this->category->name,
                'slug' => $this->category->slug,
                'icon' => $this->category->icon,
                'color' => $this->category->color,
            ] : null,
            'booking_use' => true, // Assuming all use booking for now
            'booking_price' => (string) $this->price_min,
            'booking_price_display' => $this->price_min . ' ' . 'Unit', // dynamic curr needed
        ];
    }
}
