<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Location;
use App\Models\Listing;
use Illuminate\Http\Request;
use App\Http\Resources\ListingResource;

class HomeController extends Controller
{
    public function init(Request $request)
    {
        // Return initial app config, often static or from Settings table
        return response()->json([
            'success' => true,
            'data' => [
                'app_name' => 'Listar',
                // Add more init config here
            ]
        ]);
    }

    public function widget(Request $request)
    {
        // Replicating the widget structure
        // 1. Header slider
        // 2. Categories
        // 3. Featured Listings
        
        $headerImages = [
            asset('storage/banner1.jpg'),
            asset('storage/banner2.jpg'),
        ]; // Placeholders

        $categories = Category::limit(8)->get();
        $featuredListings = Listing::where('status', 'published')->limit(5)->get();

        return response()->json([
            'success' => true,
            'data' => [
                'header' => [
                    'type' => 'basic',
                    'data' => $headerImages
                ],
                'widgets' => [
                    [
                        'title' => '',
                        'layout' => 'image-circle',
                        'type' => 'category',
                        'data' => $categories
                    ],
                    [
                        'title' => 'Explore',
                        'layout' => 'grid',
                        'type' => 'listing',
                        'data' => ListingResource::collection($featuredListings)
                    ]
                ]
            ]
        ]);
    }
}
